/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.entity.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.github.fabricators_of_create.porting_lib.entity.IEntityAdditionalSpawnData;
import io.github.fabricators_of_create.porting_lib.entity.ITeleporter;
import io.github.fabricators_of_create.porting_lib.entity.PortingLibEntity;
import io.github.fabricators_of_create.porting_lib.entity.events.EntityDataEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.EntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.EntityMountEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.MinecartEvents;
import io.github.fabricators_of_create.porting_lib.entity.extensions.EntityExtensions;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3218;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5454;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class}, priority=1759)
public abstract class EntityMixin
implements EntityExtensions {
    @Unique
    private Collection<class_1542> port_lib$captureDrops = null;
    @Shadow
    @Nullable
    private class_1297 field_6034;
    @Shadow
    private float field_18066;
    @Shadow
    private class_1937 field_6002;
    @Shadow
    private float field_6031;
    @Shadow
    private class_4048 field_18065;
    @Unique
    private class_2487 customData;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void handleSizeEvent(class_1299<?> type, class_1937 level, CallbackInfo ci) {
        float eyeHeight = ((EntityEvents.EyeHeight)EntityEvents.EYE_HEIGHT.invoker()).onEntitySize((class_1297)this, this.field_18066);
        EntityEvents.Size sizeEvent = new EntityEvents.Size((class_1297)this, class_4050.field_18076, this.field_18065, eyeHeight);
        sizeEvent.sendEvent();
        this.field_18065 = sizeEvent.getNewSize();
        this.field_18066 = sizeEvent.getNewEyeHeight();
    }

    @WrapOperation(method={"refreshDimensions"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getEyeHeight(Lnet/minecraft/world/entity/Pose;Lnet/minecraft/world/entity/EntityDimensions;)F")})
    private float entitySizeEvent(class_1297 instance, class_4050 pose, class_4048 dimensions, Operation<Float> original, @Local(index=3) class_4048 old, @Share(value="size") LocalRef<EntityEvents.Size> event) {
        EntityEvents.Size sizeEvent = new EntityEvents.Size((class_1297)this, pose, this.field_18065, old, this.method_5751(), ((Float)original.call(new Object[]{instance, pose, dimensions})).floatValue());
        event.set((Object)sizeEvent);
        sizeEvent.sendEvent();
        this.field_18065 = sizeEvent.getNewSize();
        return sizeEvent.getNewEyeHeight();
    }

    @ModifyVariable(method={"refreshDimensions"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;reapplyPosition()V"), index=3)
    private class_4048 modifyDimensions(class_4048 value, @Share(value="size") LocalRef<EntityEvents.Size> event) {
        return ((EntityEvents.Size)((Object)event.get())).getNewSize();
    }

    @ModifyReturnValue(method={"getAddEntityPacket"}, at={@At(value="RETURN")})
    private class_2596<class_2602> useExtendedSpawnPacket(class_2596<class_2602> base) {
        if (!(this instanceof IEntityAdditionalSpawnData)) {
            return base;
        }
        PortingLibEntity.LOGGER.warn(this.getClass().getSimpleName() + " is using IEntityAdditionalSpawnData without a custom packet. Please migrate to using PortingLibEntity.getEntitySpawningPacket. This functionality will be removed in 1.20.4!");
        return PortingLibEntity.getEntitySpawningPacket((class_1297)this, base);
    }

    @WrapWithCondition(method={"spawnAtLocation(Lnet/minecraft/world/item/ItemStack;F)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z")})
    public boolean port_lib$captureDrops(class_1937 level, class_1297 entity) {
        if (this.port_lib$captureDrops != null && entity instanceof class_1542) {
            class_1542 item = (class_1542)entity;
            this.port_lib$captureDrops.add(item);
            return false;
        }
        return true;
    }

    @Override
    @Unique
    public Collection<class_1542> captureDrops() {
        return this.port_lib$captureDrops;
    }

    @Override
    @Unique
    public Collection<class_1542> captureDrops(Collection<class_1542> value) {
        Collection<class_1542> ret = this.port_lib$captureDrops;
        this.port_lib$captureDrops = value;
        return ret;
    }

    @Shadow
    public abstract void method_18375();

    @Shadow
    protected abstract void method_30076();

    @Shadow
    public abstract boolean method_31481();

    @Shadow
    @Nullable
    protected abstract class_5454 method_30329(class_3218 var1);

    @Shadow
    public abstract class_1299<?> method_5864();

    @Shadow
    public abstract int method_5628();

    @Shadow
    public abstract class_4050 method_18376();

    @Shadow
    protected abstract float method_18378(class_4050 var1, class_4048 var2);

    @Shadow
    public abstract float method_5751();

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isPassenger()Z", shift=At.Shift.BEFORE)}, cancellable=true)
    public void port_lib$startRiding(class_1297 entity, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        if (!((EntityMountEvents.Mount)EntityMountEvents.MOUNT.invoker()).canStartRiding(entity, (class_1297)this)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"removeVehicle"}, at={@At(value="CONSTANT", args={"nullValue=true"})}, cancellable=true)
    public void port_lib$removeRidingEntity(CallbackInfo ci) {
        if (!((EntityMountEvents.Dismount)EntityMountEvents.DISMOUNT.invoker()).onStopRiding(this.field_6034, (class_1297)this)) {
            ci.cancel();
        }
    }

    @Inject(method={"remove"}, at={@At(value="TAIL")})
    public void port_lib$onEntityRemove(class_1297.class_5529 reason, CallbackInfo ci) {
        ((EntityEvents.Remove)EntityEvents.ON_REMOVE.invoker()).onRemove((class_1297)this, reason);
        EntityMixin entityMixin = this;
        if (entityMixin instanceof class_1688) {
            class_1688 cart = (class_1688)entityMixin;
            ((MinecartEvents.Remove)MinecartEvents.REMOVE.invoker()).minecartRemove(cart, this.field_6002);
        }
    }

    @Override
    @Unique
    public class_1297 changeDimension(class_3218 p_20118_, ITeleporter teleporter) {
        if (this.field_6002 instanceof class_3218 && !this.method_31481()) {
            this.field_6002.method_16107().method_15396("changeDimension");
            this.method_18375();
            this.field_6002.method_16107().method_15396("reposition");
            class_5454 portalinfo = teleporter.getPortalInfo((class_1297)this, p_20118_, this::method_30329);
            if (portalinfo == null) {
                return null;
            }
            class_1297 transportedEntity = teleporter.placeEntity((class_1297)this, (class_3218)this.field_6002, p_20118_, this.field_6031, spawnPortal -> {
                this.field_6002.method_16107().method_15405("reloading");
                class_1297 entity = this.method_5864().method_5883((class_1937)p_20118_);
                if (entity != null) {
                    entity.method_5878((class_1297)this);
                    entity.method_5808(portalinfo.field_25879.field_1352, portalinfo.field_25879.field_1351, portalinfo.field_25879.field_1350, portalinfo.field_25881, entity.method_36455());
                    entity.method_18799(portalinfo.field_25880);
                    p_20118_.method_18769(entity);
                    if (spawnPortal.booleanValue() && p_20118_.method_27983() == class_1937.field_25181) {
                        class_3218.method_29200((class_3218)p_20118_);
                    }
                }
                return entity;
            });
            this.method_30076();
            this.field_6002.method_16107().method_15407();
            ((class_3218)this.field_6002).method_14197();
            p_20118_.method_14197();
            this.field_6002.method_16107().method_15407();
            return transportedEntity;
        }
        return null;
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V")})
    private void saveCustomData(class_2487 tag, CallbackInfoReturnable<class_2487> cir) {
        if (this.customData != null && !this.customData.method_33133()) {
            tag.method_10566("ForgeData", (class_2520)this.customData);
        }
    }

    @Inject(method={"load"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V")})
    private void loadCustomData(class_2487 tag, CallbackInfo ci) {
        if (tag.method_10545("ForgeData")) {
            this.customData = tag.method_10562("ForgeData");
        }
    }

    @Override
    public class_2487 getCustomData() {
        if (this.customData == null) {
            this.customData = new class_2487();
        }
        return this.customData;
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="RETURN")})
    public void afterSave(class_2487 nbt, CallbackInfoReturnable<class_2487> cir) {
        ((EntityDataEvents.Save)EntityDataEvents.SAVE.invoker()).onSave((class_1297)this, nbt);
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    public void afterLoad(class_2487 nbt, CallbackInfo ci) {
        ((EntityDataEvents.Load)EntityDataEvents.LOAD.invoker()).onLoad((class_1297)this, nbt);
    }
}

